<title>Deposit - Best Leearning</title>

<?php $__env->startSection('css'); ?>
 <link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Open+Sans:300,400,600,700">
    <link rel="stylesheet" href="https://www.powerworkerearn.com/resources/css/argon.css" type="text/css">
    <link rel="stylesheet" href="https://www.powerworkerearn.com/resources/css/myapp.css" type="text/css">
    <link rel="stylesheet" href="https://www.powerworkerearn.com/resources/css/bttn.css" type="text/css">
    <style>
        body {
            font-family: 'noto serif bengali', sans-serif;
            background-color: #f4f4f4;
        }
        
        .gallery-img {
            display: flex;
            align-items: center;
            justify-content: center;
            height: calc(100% - 64px);
            padding: 15px;
            padding-top: 0;
        }
        
        .gallery-img img {
            width: auto;
            height: auto;
            max-height: 380px;
            border-radius: 8px;
            box-shadow: 0 8px 15px rgba(0,0,0,0.1);
        }
        
        .container-fluid {
            padding-right: 0px;
            padding-left: 0px;
        }

        .card {
            border-radius: 10px;
            box-shadow: 0 4px 12px rgba(0, 0, 0, 0.1);
        }

        .card-header {
            background-color: #007bff;
            color: white;
            padding: 20px;
            text-align: center;
            border-bottom: 2px solid #0056b3;
            border-radius: 10px 10px 0 0;
        }

        .card-title {
            font-size: 1.5rem;
            font-weight: 600;
            margin-bottom: 0.5rem;
            color: white;
        }

        .form-group label {
            font-weight: 500;
            color: #333;
        }

        .form-control {
            border-radius: 8px;
            padding: 12px;
            border: 1px solid #ccc;
        }

        .form-control:focus {
            border-color: #007bff;
            box-shadow: 0 0 5px rgba(0, 123, 255, 0.3);
        }

        .wallet-1 {
            border: 2px solid #ddd;
            border-radius: 8px;
            padding: 10px;
            cursor: pointer;
            transition: all 0.3s ease;
        }

        .wallet-1:hover {
            border-color: #007bff;
            transform: scale(1.05);
        }

       

        .btn-primary:hover {
            background-color: #0056b3;
            border-color: #0056b3;
        }

        .btn-info {
            background-color: #17a2b8;
            border-color: #17a2b8;
            font-size: 1rem;
        }

        .text-muted {
            font-size: 0.9rem;
            color: #777;
        }

        /* Custom marquee styling */
        marquee {
            background-color: #f8f9fa;
            padding: 10px;
            border-radius: 10px;
            color: #333;
            font-size: 1.2rem;
            font-weight: 500;
            margin-bottom: 20px;
        }

        /* Media Queries */
        @media  only screen and (max-width: 768px) {
            .wallet-1 {
                width: 100%;
                margin-bottom: 10px;
            }

            .form-control {
                width: 100%;
            }
        }

        @media  only screen and (max-width: 480px) {
            .card-title {
                font-size: 1.2rem;
            }
        }
    </style>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('user-content'); ?>
<section>
    <?php if(session('deposit_success')): ?>
        <div class="alert alert-success" style="font-weight:bold;">
            <i class="fas fa-check"></i>
            <span id="depositSuccessMessage" class="ms-3">Deposit Success</span>
            <button type="button" class="close" onclick="closeDepositMessage()">
                <span aria-hidden="true">&times;</span>
            </button>
        </div>
    <?php endif; ?>
    <div class="row justify-content-center">
        <div class="col md-6">
            <div class="card">
                <div class="card-header">
                    <h4 class="card-title">Select Account For Deposit</h4>
                    <marquee behavior="scroll" direction="left" scrollamount="5">
                                            <a href="#" class="text-primary" style="font-size: 20px;">
                            <i class="fe fe-link me-2" aria-hidden="true"></i>ডিপোজিট করার জন্য Manual Deposit অপশনে গিয়ে বিকাশ, নগদ, রকেট যে কোন একটির উপর ক্লিক করে ডিপোজিট করুন, মিনিমাম ডিপোজিট ( $1 ডলার = 100 টাকা)
                        </a>
                                    </marquee>
                    <p class="text-muted font-weight-500" style="border-radius: 4px; border: 2px solid red; padding: 5px; text-align: center; color: #fff; background-color: #f8f9fa;">
    ভেরিফিকেশন এর জন্য অপেক্ষা না করে ইন্সট্যান্ট টাকা ডিপজিট করতে চাইলে 
    <a href="/user/instant-deposit" target="_blank" style="color: #007bff; font-weight: bold;">এখানে চাপুন</a>
</p>
                </div>

                <div class="card-body">
                    <div class="mb-2">
                        <?php if(Auth::user()->earning_balance < 1): ?>
                            <button type="button" class="btn btn-sm btn-info mb-2" onclick="earningToDepositAlert()">Earning To Deposit</button>
                            <p class="text-danger" id="earning_to_deposit_error" style="display: none;">Eraning amount should be minimum 1$</p>
                        <?php else: ?>
                            <a href="javascript:;" class="btn btn-sm btn-info mb-2" onclick="openEarningToDpositForm()">Earning To Deposit</a>
                        <?php endif; ?>
                    </div>
                    
                    <div class="mb-2 d-none" id="earning_to_deposit_form">
                        <form method="POST" action="<?php echo e(route('user.earning-to-deposit')); ?>">
                            <?php echo csrf_field(); ?>
                            <div class="mb-3">
                                <label for="amount" class="form-label"><b>Amount to Transfer:</b></label>
                                <input name="amount" type="number" id="amount" class="form-control" value="<?php echo e(Auth::user()->earning_balance); ?>" placeholder="Enter amount to transfer" required>
                            </div>
                
                            <button type="submit" class="btn btn-primary">Transfer</button>
                        </form>
                    </div>

                    <form action="<?php echo e(route('user.deposit-store')); ?>" method="POST" enctype="multipart/form-data">
                        <?php echo csrf_field(); ?>
                        <div class="">
                            <div class="form-group d-flex">
                                <?php $__currentLoopData = $pay_accounts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $account): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <div class="wallet-1 m-1 c-pointer" onclick="setAccount(<?php echo e($account->id); ?>)">
                                        <img src="<?php echo e(URL::to($account->image)); ?>" class="mr-2" width="70" height="70" alt="<?php echo e($account->name); ?>">
                                    </div>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </div>

                            <input type="hidden" name="deposit_account" id="deposit_account" value="">
                            <div id="deposit_area" style="display: none;">
                                <div class="form-group">
            <h4><span id="deposit_account_text"></span> <a href="javascript:;" class="btn btn-info btn-sm" onclick="copyDepositAccountNo()">Copy</a></h4>
            <input type="hidden" value="" id="deposit_account_no" required>
            <p id="deposit_account_guideline"></p>
        </div>
                                <div class="form-group">
                                    <h4 id="deposit_account_text"></h4>
                                    <p>
                                        <span class="text-red text-muted font-weight-500">Minimum deposit amount: (1$= 100 BDT)</span> <br>Any deposits less than 1 USD will not be credited or refunded.<br><b>Send Money to below Number</b></p>
                                    </p>
                                </div>
                                <hr class="red-hr">
                                <div class="form-group">
                                    <label for="link" class="text-muted font-weight-500">Amount (Minimum 1$)</label>
                                    <input class="form-control" type="number" name="amount" value="0" min="1" step="0.01" placeholder="Deposit Amount">
                                    <small class="text-muted text-red font-weight-600" id="wallet-amount-info" style="margin-top: 8px; margin-left: 2%; display: block;"></small>
                                </div>

                                <div class="form-group">
                                    <label for="phone" class="text-muted font-weight-500">Sent From</label>
                                    <input class="form-control" type="text" name="phone" placeholder="Sender Account Number">
                                </div>

                                <div class="form-group">
                                    <label for="transaction_id" class="text-muted font-weight-500">Transaction ID </label>
                                    <input class="form-control" type="text" name="transaction_id" placeholder="Transaction ID">
                                </div>
                                
                                <div class="form-group">
                                    <input type="file" style="display: none"  name="receipt" required id="screen_shot_select_image" accept="image/x-png,image/jpg,image/jpeg" onChange="readURL();" lang="en">
                                    <label class="custom-file-label-drop" for="screen_shot_select_image"><i class="fas fa-camera"></i> Screenshot </label>
                                     <small class="text-danger" id="file-error"></small>
                                    <div class="gallery-img">
                                        <img class="mt-2" id="screen_shot_show_image" id="photo" src="#" style="display:none; max-width: 95%;" />
                                    </div>
                                </div>
                                
                                <div class="form-group text-right">
                                    <!--<button type="submit" class="btn btn-primary mt-4 mb-0">Submit</button>-->
                                    <button type="button" name="" class="btn btn-outline-info mt-4 mb-0 bttn" data-toggle="modal" data-target="#modalConfirm"><i class="fas fa-check"></i> Submit</button>
                                </div>
                                <!-- Add this modal confirmation dialog -->
                                    <div class="modal fade" id="modalConfirm" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
                                        <div class="modal-dialog modal-dialog-centered" role="document">
                                            <div class="modal-content">
                                                <div class="modal-body">
                                                  <h4 class="text-red">Sir,  Please check your information again.</h4>
                                                  <br>
                                                  <p class="tab-title-header h2">Are you confirm ?</p>
                                               </div>
                                                <div class="modal-footer">
                                                    <button type="button" class="btn btn-success bttn" data-dismiss="modal" id="btnSubmit">Yes, Confirm</button>
                                                    <button type="button" class="btn btn-default" data-dismiss="modal">No</button>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</section>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('js'); ?>
<!-- Popper.js -->
<script src="https://cdnjs.cloudflare.com/ajax/libs/popper.js/1.14.7/umd/popper.min.js" integrity="sha384-UO2eT0CpHqdSJQ6hJty5KVphtPhzWj9WO1clHTMGa3JDZwrnQq4sF86dIHNDz0W1" crossorigin="anonymous"></script>

<!-- Bootstrap JS -->
<script src="https://stackpath.bootstrapcdn.com/bootstrap/4.3.1/js/bootstrap.min.js" integrity="sha384-JjSmVgyd0p3pXB1rRibZUAYoIIy6OrQ6VrjIEaFf/nJGzIxFDsf4x0xIM+B07jRM" crossorigin="anonymous"></script>
<script src="https://code.jquery.com/jquery-3.6.4.min.js"></script>
    <script>
        function setAccount(account_id){
            $('#deposit_account').val(account_id);

            $.ajax({
                url: "<?php echo e(route('user.deposit-account-info')); ?>",
                type:"POST",
                data:{
                    _token: '<?php echo e(csrf_token()); ?>',
                    account_id: account_id,
                },
                success:function(data) {
                    console.log(data);
                    $('#deposit_area').show();
                    $('#deposit_account_text').html('Account No: '+data);
                    // $('#deposit_account_text').html('Account No: '+data['account_no']);
                    // $('#deposit_account_guideline').html(data['guideline']);
                },
            });
        }
        
        function copyDepositAccountNo(){
            var deposit_account_no = $('#deposit_account_no').val();
            navigator.clipboard.writeText(deposit_account_no);
            alert('Account number copied!');
        }
        
        function readURL(){
            var file = $('#screen_shot_select_image').get(0).files[0];
            console.log(file);
            if(file){
                $('#screen_shot_show_image').show();
                var reader = new FileReader();
     
                reader.onload = function(){
                    $('#screen_shot_show_image').attr("src", reader.result);
                }
     
                reader.readAsDataURL(file);
            }
        }
        
        function earningToDepositAlert(){
            $('#earning_to_deposit_error').show();
        }
        
        function updatePayout() {
            let depositAmount = parseFloat($('input[name="amount"]').val());
        
            if (isNaN(depositAmount) || depositAmount < 1) {
                $('#wallet-amount-info').text('');
                $('#wallet-amount-info').fadeIn();
                return;
            }
        
            let payoutAmount = depositAmount * 100;  
        
            $('#wallet-amount-info').text(`$1 = 100 | Please Send: ${payoutAmount.toFixed()} USD`);
            $('#wallet-amount-info').fadeIn();
        }
        
        // Call the function when the amount changes
        $('input[name="amount"]').on('input', function() {
            updatePayout();
        });
        
        // Call the function on page load
        $(document).ready(function() {
            updatePayout();
        });

    </script>
    <script>
    document.addEventListener('DOMContentLoaded', function () {
        var confirmButton = document.getElementById('btnSubmit');

        // Attach a click event listener to the confirm button
        confirmButton.addEventListener('click', function () {
            // Find the closest form and submit it when the user confirms
            var form = confirmButton.closest('form');
            if (form) {
                form.submit();
            }
        });
    });
    
    function closeDepositMessage() {
        var depositMessage = document.querySelector('.alert-success');
        depositMessage.style.display = 'none';
    }
     
    function readURL() {
            var file = $('#screen_shot_select_image').get(0).files[0];
            var errorElement = document.getElementById('file-error');
            
            if (file) {
                // Check file size (max 1MB)
                if (file.size > 1048576) { // 1048576 bytes = 1MB
                    errorElement.textContent = "File size must be less than or equal to 1MB.";
                    $('#screen_shot_select_image').val(''); // Clear the input
                    $('#screen_shot_show_image').hide(); // Hide the image preview
                    return;
                } else {
                    errorElement.textContent = ""; // Clear error message
                }
    
                // Show image preview
                $('#screen_shot_show_image').show();
                var reader = new FileReader();
    
                reader.onload = function () {
                    $('#screen_shot_show_image').attr("src", reader.result);
                }
    
                reader.readAsDataURL(file);
            }
        }
        
    function openEarningToDpositForm(){
        $('#earning_to_deposit_form').removeClass('d-none');
    }
    
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('user.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/asditzone/public_html/resources/views/user/pages/deposit.blade.php ENDPATH**/ ?>